// ページネーションの非表示・パネルの新規作成
async function initial() {
    console.log("初期処理を実施します");

    // ヘッダーバナーを非表示にしてパネルを追加する
    document.querySelector(".header_banner").children[0].remove();
    let panelHeaderDOM = document.createElement('div');
    panelHeaderDOM.innerHTML =
        `<div style="border: solid 2px #fe7177; padding: 0 0 0 0; margin:10px 0 10px 0;">
            <div style="padding:6px 0 5px 10px; background:#fe7177">
                <div id="" style="font-size: 20px;">WithBlockChecker</div>
                <div id="addonMessage" style="font-size: 15px;">情報取得中…</div>
            </div>
            <ul id="panel" style="display: inline;">
            </ul>
        </div>`;
    document.querySelector(".header_banner").prepend(panelHeaderDOM);
}

// ページ番号をインクリメントしながらデータを取得して整形して保存する関数
// 全メンバーとトークの再取得・メンバー数の計測/パネルの更新・メンバー情報の更新/比較
async function update(startPage = 1, endPage = 100) {
    console.log("更新処理を実施します");
    let newJson = {
        previousMemberCount: 0,
        lastMemberCount: 0,
        member: {}
    };

    const addonMessage = document.getElementById("addonMessage");
    if (addonMessage) {
        addonMessage.textContent = "情報更新中…";
    }

    for (let page = startPage; page <= endPage; page++) {
        const url = `https://with.is/messages?page=${page}`;
        try {
            const response = await fetch(url, { credentials: 'include' });
            if (response.ok) {
                const text = await response.text();
                const parser = new DOMParser();
                const doc = parser.parseFromString(text, 'text/html');
                const messages = doc.querySelectorAll('li.topic-list');

                if (messages.length === 0) {
                    console.log("No more messages found.");
                    break;
                }

                messages.forEach((li) => {
                    const aTag = li.querySelector("a.topic_contents");
                    const href = aTag ? aTag.getAttribute("href") : "";
                    const id = href.replace("/messages/", "");

                    const name = li.querySelector(".topic_nickname")?.textContent.trim() || "";
                    const ageAddress = li.querySelector(".topic_age-address")?.textContent.trim() || "";
                    const ageMatch = ageAddress.match(/(\d+)歳/);
                    const age = ageMatch ? parseInt(ageMatch[1], 10) : null;
                    const address = ageAddress.replace(/^\d+歳\s*/, "").trim();
                    const lastDate = li.querySelector(".topic_info-right")?.textContent.trim() || "";
                    const lastMessage = li.querySelector(".topic_message")?.textContent.trim() || "";

                    newJson.member[id] = {
                        id,
                        name,
                        age,
                        address,
                        lastDate,
                        lastMessage
                    };
                });

                console.log(`Fetched and processed page ${page}`);
            } else {
                console.error(`Failed to fetch page ${page}: ${response.status}`);
                break;
            }
        } catch (error) {
            console.error(`Error fetching page ${page}:`, error);
        }
    }

    const oldDataStr = localStorage.getItem("membersData");
    if (oldDataStr) {
        const oldJson = JSON.parse(oldDataStr);

        const oldIds = new Set(Object.keys(oldJson.member));
        const newIds = new Set(Object.keys(newJson.member));

        // 取得できなかったメンバー
        const removed = [...oldIds].filter(id => !newIds.has(id));

        newJson.previousMemberCount = oldJson.lastMemberCount || 0;
        newJson.lastMemberCount = Object.keys(newJson.member).length;

        // panelに表示
        const panel = document.getElementById("panel");
        if (panel) {
            panel.innerHTML = ""; // 初期化

            if (addonMessage) {
                if (removed.length === 0) {
                    addonMessage.textContent = "非表示になったメンバーはいません";
                } else {
                    addonMessage.textContent = `非表示になったメンバーが ${removed.length} 件見つかりました`;
                }
            }

            removed.forEach(id => {
                const m = oldJson.member[id];
                if (m) {
                    const li = document.createElement("li");
                    li.className = "topic";
                    li.setAttribute("onMouseOut", "this.style.background='';");
                    li.setAttribute("onMouseOver", "this.style.background='#ededed';");

                    li.innerHTML = `
                        <a href="/messages/${m.id}" style="display:flex; padding:12px 16px">
                            <div class="topic_partner" style="width:90%;">
                                <div class="topic_names-wrap">
                                    <div class="topic_nickname text-ellipsis">${m.name}</div>
                                    <div class="topic_age-address">${m.age ?? ""}歳 ${m.address}</div>
                                    <div class="topic_info-right">
                                        <span class="text-black40 size11" style="text-align: right;">
                                            ${m.lastDate}
                                        </span>
                                    </div>
                                </div>
                                <div class="topic_message" style="overflow-wrap: break-word; height: auto;">
                                    <span>${m.lastMessage}</span>
                                </div>
                            </div>
                            <button class="deleteBtn" data-id="${m.id}" 
                                onMouseOut="this.style.background='';" 
                                onMouseOver="this.style.background='#cb5a5f'" 
                                style="width:10%; border: solid 1px gray; border-radius:20px;">
                                削除
                            </button>
                        </a>
                    `;
                    panel.appendChild(li);
                }
            });

            // 削除ボタン処理
            panel.querySelectorAll(".deleteBtn").forEach(btn => {
                btn.addEventListener("click", (e) => {
                    e.preventDefault(); 
                    const id = e.target.dataset.id;
                    if (id && oldJson.member[id]) {
                        if (confirm(`「${oldJson.member[id].name}」を削除しますか？`)) {
                            delete oldJson.member[id]; 
                            e.target.closest("li").remove(); 
                            localStorage.setItem("membersData", JSON.stringify(oldJson));
                        }
                    }
                });
            });
        }

        // メンバー更新
        Object.keys(newJson.member).forEach(id => {
            oldJson.member[id] = newJson.member[id];
        });
        oldJson.previousMemberCount = newJson.previousMemberCount;
        oldJson.lastMemberCount = newJson.lastMemberCount;

        localStorage.setItem("membersData", JSON.stringify(oldJson));
        console.log("更新保存完了:", oldJson);
    } else {
        // 初期保存
        newJson.lastMemberCount = Object.keys(newJson.member).length;
        localStorage.setItem("membersData", JSON.stringify(newJson));

        if (addonMessage) {
            addonMessage.textContent = "非表示になったメンバーはいません";
        }
        console.log("初期保存完了:", newJson);
    }
}

async function main() {
    // 初期処理
    await initial();

    // 更新処理
    await update();
}

main();
